#!/usr/bin/perl -w
#
# install host or guest rpm-file in current directory.
# (c) Netop Business Solutions A/S 2016
#
my $VERSION = "debinst: 1.04";
my $DEBUG = 0;

package debinst;
@EXPORT = qw(install_guestx32);
@EXPORT = qw(install_hostx32);
@EXPORT = qw(install_guestx64);
@EXPORT = qw(install_hostx64);
@EXPORT = qw(install_pammodules64);

my $DEB_CMD;
my $LS_CMD;
my $AUTOINSTALL;
my $PRODUCT_VERSION = ""; # modify in install.pl

sub get_tools
{
    $APT_CMD          =  $ENV{"APT_CMD"};
    $DPKG_CMD         =  $ENV{"DPKG_CMD"};
    $LS_CMD           =  $ENV{"LS_CMD"};
    $AUTOINSTALL      =  $ENV{"AUTOINSTALL"};
    $PRODUCT_VERSION  =  $ENV{"NETOP_PRODUCT_VERSION"};
}

sub dbg
{
    if($DEBUG) {
        my $arg = shift(@_);
        print STDERR "DBG: $arg";
    }
}

sub install_public_key
{
    my ($mydir)=@_;
    my $keyid=system("./installpubkey '$mydir/netop.pub'");
}

sub install_deb3
{
    my ($install_dir,$debfile) = @_;
    #  install_public_key($install_dir);

    # FIX DE8545 :
    # The gdebi installer asks the user a question ( if s/he really wants to install
    # the deb package ) and expects a Y/N answer.
    # If the answer is N(o) then the package is NOT installed, but the return status
    # is 0 (OK), because, from the PoV of gdebi the operation completed successfully.
    # We need to intercept the user's input and evaluate it after the gdebi completes
    # in order to decide it the package was actually installed.

    my $command = "$DPKG_CMD -i $debfile && $APT_CMD -f install";
    dbg("issue command: $command\n");
    
    # FIX DE8512 , support --autoinstall flag
    if ( 'y' eq $AUTOINSTALL )
    {
        my $result = `$command`;
        if ( 0 == $? ) { return 1; }
        return 0;
    }
    # interactive install :
    # install SIGPIPE handler
    local $SIG{PIPE} = sub { die "Internal error, broken pipe!\n" }; 
    # Spawn the command in a sub-process and control the I/O :
    my $child_pid = open(my $pipe, "|-", $command);
    # open/pipe failed ?
    #unless defined( $child_pid )
    do
    {
        print STDERR "Internal installer error (open() failed with $?).\n";
        return 0; # EXIT_FAIL
    } unless defined( $child_pid );
    # $DEB_CMD failed ?
    if ( 0 != $? )
    {
        print STDERR "External installer error ($DEB_CMD failed with $?).\n";
        return 0; # EXIT_FAIL
    }
    # open() OK, subprocess spawned :
    # gdebi will ask user a question, read the user's answer : 
    my $answer = <STDIN>;
    # forward it to subprocess' stdin :
    print $pipe "$answer\n";
        # wait for subprocess to finish
        # waitpid( $child_pid, 0 ); # don't wait !
        # $answer =~ s/^\s+//; #ltrim
        # $answer =~ s/\s+$//; #rtrim
    $answer = lc substr($answer, 0, 1); # extract the 1st character only
    # user answered 'Yes' and the package was installed :
    if ( $answer eq 'y' ) { return 1; }
    # user answers 'No' or anything else :
    return 2;
    # other package managers allow a (C)ancel and other stuff :
    # user answered 'No' and  the package was not installed :
    #if ( $answer eq 'n' ) { return 2; }
    # unkown : TODO 
    #return 0;
} # sub install_deb

sub install_deb
{
    my ($install_dir,$debfile, $pkgname) = @_;
    my $dpkg_command = "$DPKG_CMD -i $debfile 2>&1 1> /dev/null";
    my $apt_command = "$APT_CMD -y -f install 2>&1 1> /dev/null";
    my $result = `$dpkg_command`;
    my $dpkg_result = $?;
    my $apt_result = $?;
    

    if ( 0 != $dpkg_result )
    {
        $result = `$apt_command`;
        $apt_result = $?;
        if( 0 != $apt_result)
        {
            $apt_result = `$DPKG_CMD --purge $pkgname $pkgname:i386 2>&1 1> /dev/null`;
            return 0;
        }
    }
    return 1;
}

sub install_hostx32()
{
    dbg("Install host from deb\n");
    get_tools();
    my $res = 1;
    my ($install_dir) = @_;
    my $debfile = `$LS_CMD NetopHost*.i386.deb`;
    $debfile =~ s/\n//g;
    die "package not found\n" if(!($debfile =~ m|.*$PRODUCT_VERSION|));
    return install_deb($install_dir,$debfile, "netophost");
}

sub install_hostarmel()
{
    dbg("Install host from deb\n");
    get_tools();
    my $res = 1;
    my ($install_dir) = @_;
    my $debfile = `$LS_CMD NetopHost*.armel.deb`;
    $debfile =~ s/\n//g;
    die "package not found\n" if(!($debfile =~ m|.*$PRODUCT_VERSION|));
    return install_deb($install_dir,$debfile, "netophost");
}

sub install_hostarmhf()
{
    dbg("Install host from deb\n");
    get_tools();
    my $res = 1;
    my ($install_dir) = @_;
    my $debfile = `$LS_CMD NetopHost*.armhf.deb`;
    $debfile =~ s/\n//g;
    die "package not found\n" if(!($debfile =~ m|.*$PRODUCT_VERSION|));
    return install_deb($install_dir,$debfile, "netophost");
}

sub install_hostx64()
{
    dbg("Install host from deb\n");
    get_tools();
    my $res = 1;
    my ($install_dir) = @_;
    my $debfile = `$LS_CMD NetopHost*.amd64.deb`;
    $debfile =~ s/\n//g;
    die "package not found\n" if(!($debfile =~ m|.*$PRODUCT_VERSION|));
    return install_deb($install_dir,$debfile, "netophost");
}


sub install_guestx32()
{
    dbg("Install guest deb\n");
    get_tools();
    my ($install_dir) = @_;
    my $debfile = `$LS_CMD NetopGuest*.i386.deb`;
    $debfile =~ s/\n//g;
    die "package not found\n" if(!($debfile =~ m|.*$PRODUCT_VERSION|));

    return install_deb($install_dir,$debfile, "netopguest");
}

sub install_guestx64()
{
    dbg("Install guest deb\n");
    get_tools();
    my ($install_dir) = @_;
    my $debfile = `$LS_CMD NetopGuest*.amd64.deb`;
    $debfile =~ s/\n//g;
    die "package not found\n" if(!($debfile =~ m|.*$PRODUCT_VERSION|));

    return install_deb($install_dir,$debfile, "netopguest");
}

sub install_pammodules64()
{
    dbg("Install pam 32 bit modules");
    get_tools();
    my ($install_dir) = @_;
    my $debfile = `$LS_CMD libpam-modules*_i386.deb`;
    $debfile =~ s/\n//g;
    if(!($debfile =~ m|.*_i386|)){
        return 0;
    }
    my $cmd="";
    if (! -e "/lib32"){
        mkdir "/lib32";
        mkdir "/lib32/security";
    }else{
        if(! -e "/lib32/security"){
            mkdir "/lib32/security";
        }
    }
    mkdir "/tmp/nrcpam32";
    $cmd = "dpkg-deb -x $debfile /tmp/nrcpam32 && mv /tmp/nrcpam32/lib/security/*.so /lib32/security";
    my $res = system($cmd) ;
    if($res != 0) {
        print STDERR "install_deb: '$cmd' failed with status $res\n";
        return 0;
    }
    return 1;
}

return 1;
