#!/usr/bin/perl -w
#
# install host or guest rpm-file in current directory.
# (c) Netop Business Solutions A/S 2016
#
my $VERSION = "yuminst: 1.04";
my $DEBUG = 0;

package zypinst;
@EXPORT = qw(install_guest);
@EXPORT = qw(install_host);

my $ZYP_CMD;
my $RPM_CMD;
my $LS_CMD;
my $AUTOINSTALL;
my @PRODUCT_VERSION = ( "0", "0" ); # modify in install.pl

sub get_tools
{
    $ZYP_CMD          =  $ENV{"ZYP_CMD"};
    $RPM_CMD          =  $ENV{"RPM_CMD"};
    $LS_CMD           =  $ENV{"LS_CMD"};
    $AUTOINSTALL      =  $ENV{"AUTOINSTALL"};
    $PRODUCT_VERSION[0] = $ENV{"NETOP_PRODUCT_VERSION_MJ"};
    $PRODUCT_VERSION[1] = $ENV{"NETOP_PRODUCT_VERSION_MN"};
}

sub dbg
{
    if($DEBUG) {
        my $arg = shift(@_);
        print STDERR "DBG: $arg";
    }
}

sub install_public_key
{
    my ($mydir)=@_;
    my $keyid=system("./installpubkey '$mydir/netop.pub'");
}

# FIX DE8545 : @see debinst.pm for extended explanation of open+pipe
sub install_rpm
{
    my $command = undef;
    my ($install_dir,$rpmfile) = @_;
    install_public_key($install_dir);
    $command = "$ZYP_CMD in $rpmfile";
    dbg("$cmd\n");

    # FIX DE8545 : can't use the pipe trick from deb, because zypper binary behaves differently
    # FIX DE8512 , support --autoinstall flag, useless because of DE8545
    #if ( 'y' eq $AUTOINSTALL )
    #{
        my $result = `$command`;
        if ( 0 == $? ) { return 1; }
        print STDERR "install_rpm: '$command' failed with status $result\n";
        return 0;
        #}
    # older :
    #my $res = system($cmd) ;
    #if($res != 0) {
    #    print STDERR "install_rpm: '$cmd' failed with status $res\n";
    #    return 0;
    #}
    #return 1;
}

sub install_host()
{
    dbg("Install host from rpm\n");
    get_tools();
    my $res = 1;
    my ($install_dir) = @_;
    my $rpmfile = `$LS_CMD NetopHost*.rpm`;
    $rpmfile =~ s/\n//g;
    die "package not found\n" if(!($rpmfile =~ m|.*$PRODUCT_VERSION[0].$PRODUCT_VERSION[1]|));
    $cmd = "$RPM_CMD -q NetopHost";
    my $installed = `$cmd`;
    $installed =~ s/\n//g;
    if($installed =~ m|NetopHost-(....)-(........)|) {
        dbg("NetopHost allready installed : '$installed' !\n");
        if(-e "/etc/init.d/netophostd") {
            $cmd = "/etc/init.d/netophostd stop >/dev/null 2>/dev/null";
            dbg("$cmd\n");
            `$cmd`;
        }

        $cmd = "$YUM_CMD erase -y $installed";
        dbg("$cmd\n");
        `$cmd`;
    }
    $cmd = "$ZYP_CMD in pam-modules-32bit";
    dbg("$cmd\n");
    my $rsp = system($cmd) ;
    return install_rpm($install_dir,$rpmfile);
}

sub install_guest()
{
    dbg("Install guest rpm\n");
    get_tools();
    my ($install_dir) = @_;
    my $rpmfile = `$LS_CMD NetopGuest*.rpm`;
    $rpmfile =~ s/\n//g;
    die "package not found\n" if(!($rpmfile =~ m|.*$PRODUCT_VERSION[0].$PRODUCT_VERSION[1]|));

    $cmd = "$RPM_CMD -q NetopGuest";
    my $installed = `$cmd`;
    $installed =~ s/\n//g;
    if($installed =~ m|NetopGuest-(....)-(........)|) {
        dbg("Netop Guest allready installed : '$installed' !\n");
        $cmd = "$RPM_CMD -e $installed";
        $res = system("$cmd");
        if($res != 0) {
            print STDERR "install_host: '$cmd' failed with status $res, trying to upgrade.\n";
        }
    }
    return install_rpm($install_dir,$rpmfile);
}

return 1;
