#!/usr/bin/perl -w
#
# install host or guest tarfile in current directory.
# (c) Netop Business Solutions A/S 2016
#
my $VERSION = "tarinst: 1.04";
my $DEBUG = 0;

package tarinst;
@EXPORT = qw(install_guest);
@EXPORT = qw(install_host);

my $TARGET_DEST = "";

my $PERL_CMD;
my $CP_CMD;
my $LS_CMD;
my $TAR_CMD;
my $RPM_CMD;
my $TAR_EXTRACT;
my $TAR_TOC;
my $TAR_EXTRACT_CMD;
my $TAR_TOC_CMD;
my $TAR_EXTENSION;
my $GZCAT_CMD;

my $CONFIGURE_SCRIPT = "/etc/NetopHost/cfg/configure.pl";
my $UNCONFIGURE_SCRIPT = "/etc/NetopHost/cfg/unconfigure.pl";
my $RUN_SIGNALFILE = "/var/run/NetopHost.running";

my @PRODUCT_VERSION = ( "0", "0" ); # modify in install.pl

sub get_tools
{
    $PERL_CMD         =  $ENV{"PERL_CMD"};
    $CP_CMD           =  $ENV{"CP_CMD"};
    $LS_CMD           =  $ENV{"LS_CMD"};
    $TAR_CMD          =  $ENV{"TAR_CMD"};
    $RPM_CMD          =  $ENV{"RPM_CMD"};
    $TAR_EXTRACT      =  $ENV{"TAR_EXTRACT"};
    $TAR_TOC          =  $ENV{"TAR_TOC"};
    $TAR_EXTRACT_CMD  =  $ENV{"TAR_EXTRACT_CMD"};
    $TAR_TOC_CMD      =  $ENV{"TAR_TOC_CMD"};
    $TAR_EXTENSION    =  $ENV{"TAR_EXTENSION"};
    $GZCAT_CMD        =  $ENV{"GZCAT_CMD"};
    $PRODUCT_VERSION[0] = $ENV{"NETOP_PRODUCT_VERSION_MJ"};
    $PRODUCT_VERSION[1] = $ENV{"NETOP_PRODUCT_VERSION_MN"};
}

sub tar_extract_cmd
{
    dbg("test_tools:\n");
    my ($tarfile) = @_;
    my $cmd = "$TAR_TOC_CMD $tarfile 2>/dev/null";
    dbg("test_tools: cmd: $cmd\n");
    my $tst = `$cmd`;
    my $st = $?;
    $st >>= 8;
    dbg("test_tools: st: $st\n");
    if ($st == 0) {
        return "$TAR_EXTRACT_CMD $tarfile";
    }

    dbg("tar z-option not supported\n");
    die "z-option not supported and no gzcat" if (! -e $GZCAT_CMD);
    return "$GZCAT_CMD $tarfile | $TAR_CMD xvf -";
}

sub tar_toc_cmd
{
    dbg("test_tools:\n");
    my ($tarfile) = @_;
    my $cmd = "$TAR_TOC_CMD $tarfile 2>/dev/null";
    dbg("test_tools: cmd: $cmd\n");
    my $tst = `$cmd`;
    my $st = $?;
    $st >>= 8;
    dbg("test_tools: st: $st\n");
    if($st == 0) {
        return "$TAR_TOC_CMD $tarfile";
    }

    dbg("tar z-option not supported\n");
    dbg("GZCAT_CMD = $GZCAT_CMD\n");
    die "z-option not supported and no gzcat" if (! -e $GZCAT_CMD);
    return "$GZCAT_CMD $tarfile | $TAR_CMD tvf -";
}

sub dbg
{
    if ($DEBUG) {
        my ($arg) = @_;
        print STDERR "DBG: $arg";
    }
}

$UNINSTALL_SCRIPT = "";
$UNINSTALL_COMMANDS = "";

sub  write_uninstall
{
   open OUTFILE,">$UNINSTALL_SCRIPT" or die "Cannot open '$UNINSTALL_SCRIPT' for writing: $!\n";
   printf OUTFILE "%s", $UNINSTALL_COMMANDS;
   close OUTFILE;
}

$TMP_LOCATION   = "/tmp/.Netop_install";

sub  create_dir
{
    my ($dirname) = @_;
    if (!(-e $dirname)) {
        dbg("Creating directory $dirname\n");
        $cmd = "mkdir -p $dirname";
		  if (system $cmd) {
				die "error in $cmd\n";
		  }
    }
    if( !(-d $dirname)) {
        die "could not create $dirname\n";
    }
}

sub decode_mode_bits
{
    my $octal=0;
    my ($sym_mode) = @_;
    if($sym_mode =~ "r") {
        $octal += 4;
    }
    if($sym_mode =~ "w") {
        $octal += 2;
    }
    if($sym_mode =~ "x" || $sym_mode =~ "s") {
        $octal += 1;
    }
    return "$octal";
}

sub decode_mode
{
    my ($o_sym_mode,$g_sym_mode,$a_sym_mode) = @_;

    my $omode = decode_mode_bits($o_sym_mode);
    my $gmode = decode_mode_bits($g_sym_mode);
    my $amode = decode_mode_bits($a_sym_mode);

    return "0$omode$gmode$amode";
}

sub cleanup_tmp
{
    my $dir = $TMP_LOCATION;
    if(-l $dir) {
		  my $count = unlink $dir;
		  die "Could not unlink $dir\n" if ($count ne "1");
    }
    if (-d $dir) {
        $cmd = "chmod -R +w $TMP_LOCATION";
		  if( system $cmd ) {
            print "Could not change mode below $TMP_LOCATION\n";
        }
        $cmd = "rm -rf $TMP_LOCATION";
		  if( system $cmd ) {
            print "Could not remove existing $TMP_LOCATION\n";
		  }
    }
}

sub cp_tmp_to_final_location
{
    my $filename = "";
    while (my $tarentry = shift(@_)) {
        if ($tarentry =~ "[.][/](.*)") {
            $filename = $1;
        } else {
            # TBV: move directly from /tmp without this information ?
            die "error [1] in tar output format\n";
        }
        if( $tarentry =~ m|(.)(...)(...)(...)[ ]+[^ ]+[ ]+([0-9]+)| ) {
            my $size  = $5;
            # decode mode
            my $sym_octal_mode  = decode_mode($2,$3,$4);
            my $is_file;
            if($1 eq "d") {
                $is_file = 0;
                # print "Directory: $filename\n";
                if (($filename =~ "etc/netop") or ($filename =~ "doc/netop") or ($filename =~ "opt/") or ($TARGET_DEST ne "")) {
                    if(! -d "$TARGET_DEST/$filename") {
                        my $cmd = "mkdir -p \"$TARGET_DEST/$filename\"";
                        dbg("$cmd\n");
                        system($cmd);
                    }
                }
            } else {
                $is_file = 1;
                # print "Filesize: $size $filename\n";
                if( -e "$TARGET_DEST/$filename") {
                    # backup, unlink ?
                    chmod 0744, "$TARGET_DEST/$filename";
                }
                my $cmd = "$CP_CMD \"./$filename\" \"$TARGET_DEST/$filename\"";
                dbg("$cmd\n");
                system($cmd);
                $UNINSTALL_COMMANDS .= "unlink \"$TARGET_DEST/$filename\";\n";
            }
            if($is_file) {
                dbg("chmod $sym_octal_mode, $TARGET_DEST/$filename\n");
                chmod oct $sym_octal_mode, "$TARGET_DEST/$filename";
            } else {
                if(($filename =~ "etc/netop") or ($TARGET_DEST ne "")) {
                    dbg("chmod $sym_octal_mode, $TARGET_DEST/$filename\n");
                    chmod oct $sym_octal_mode, "$TARGET_DEST/$filename";
                }
            }
        } else {
            # TBV: move directly from /tmp without this information ?
            die "error [2] in tar output format\n";
        }
    }
    write_uninstall();

    return 1;
}

sub create_tmpdir
{
    cleanup_tmp();
    create_dir("$TMP_LOCATION");

    return 1;
}

sub install_tar
{
    my $res = 1;
    my ($install_dir,$tarfile) = @_;

    umask(022);

    die if(!create_tmpdir());

    my $cmd = tar_toc_cmd("$install_dir/$tarfile");
    my @filelist = `$cmd`;
    chdir $TMP_LOCATION or die "Cannot change directory to $TMP_LOCATION\n";

    $cmd = tar_extract_cmd("$install_dir/$tarfile");
    dbg("cmd: $cmd\n");

    if(system($cmd)) {
        $res = 0;
    } else {
        cp_tmp_to_final_location(@filelist);
    }

    chdir $install_dir or die "Cannot change directory to $install_dir\n";
    cleanup_tmp;

    return $res;
}

sub install_host()
{
    dbg("Install host from .tar.gz\n");
    get_tools();
    my $res = 1;
    my ($install_dir) = @_;
    my $tarfile = "netophos.gz";
    if(! -e $tarfile) {
        $tarfile = `$LS_CMD NetopHost*$TAR_EXTENSION`;
        $tarfile =~ s/\n//g;
        die "package not found\n" if(!($tarfile =~ m|.*$PRODUCT_VERSION[0].$PRODUCT_VERSION[1]|));
	 }
    $UNINSTALL_SCRIPT = "/etc/NetopHost/cfg/uninstall.pl";
    if (-e $UNINSTALL_SCRIPT) {
		  `$PERL_CMD $UNINSTALL_SCRIPT`;
    }
    unlink $UNINSTALL_SCRIPT;
    $UNINSTALL_COMMANDS = "#!$PERL_CMD -w\n";
    $UNINSTALL_COMMANDS .= "if( -e \"$UNCONFIGURE_SCRIPT\") {\n";
    $UNINSTALL_COMMANDS .= "   \`$PERL_CMD $UNCONFIGURE_SCRIPT\`;\n";
    $UNINSTALL_COMMANDS .= "}\n";
    $UNINSTALL_COMMANDS .= "if( -e \"/etc/init.d/netophostd\") {\n";
    $UNINSTALL_COMMANDS .= "   \`/etc/init.d/netophostd stop\`;\n";
    $UNINSTALL_COMMANDS .= "}\n";

    my $rc = install_tar($install_dir,$tarfile);
    $UNINSTALL_COMMANDS .= "unlink \"$UNCONFIGURE_SCRIPT\";\n";
    $UNINSTALL_COMMANDS .= "unlink \"$CONFIGURE_SCRIPT\";\n";
    $UNINSTALL_COMMANDS .= "unlink \"$UNINSTALL_SCRIPT\";\n";
    $UNINSTALL_COMMANDS .= "unlink \"$RUN_SIGNALFILE\";\n";
    $UNINSTALL_COMMANDS .= "rmdir \"/etc/NetopHost/cfg\";\n";
    $UNINSTALL_COMMANDS .= "rmdir \"/opt/NetopHost/qxmlicons\";\n";
    $UNINSTALL_COMMANDS .= "rmdir \"/opt/NetopHost\";\n";

    write_uninstall();
    chmod 0744,$UNINSTALL_SCRIPT;
    print "Uninstall script is written to $UNINSTALL_SCRIPT \n";
    return $rc;
}

sub install_guest()
{
    dbg("Install guest from .tar.gz\n");
    get_tools();
    dbg("LS_CMD  = $LS_CMD\n");
    my ($install_dir) = @_;
    my $tarfile = "netopgue.gz";
    if(! -e $tarfile) {
        $tarfile = `$LS_CMD NetopGuest*$TAR_EXTENSION`;
        $tarfile =~ s/\n//g;
        die "package not found\n" if (!($tarfile =~ m|.*$PRODUCT_VERSION[0].$PRODUCT_VERSION[1]|));
    }
    $UNINSTALL_SCRIPT = "/etc/netopguest/uninstall.pl";
    unlink $UNINSTALL_SCRIPT;
    $UNINSTALL_COMMANDS = "#!/usr/bin/perl -w\n";
    my $rc = install_tar($install_dir, $tarfile);
    $UNINSTALL_COMMANDS .= "unlink \"$UNINSTALL_SCRIPT\";\n";
    write_uninstall();
    chmod 0744,$UNINSTALL_SCRIPT;
    print "Uninstall script is written to $UNINSTALL_SCRIPT\n";
    return $rc;
}

return 1;
