#!/usr/bin/perl -w
#
# install host or guest rpm-file in current directory.
# (c) Netop Business Solutions A/S 2016
#
my $VERSION = "rpminst: 1.04";
my $DEBUG = 0;

package rpminst;
@EXPORT = qw(install_guest);
@EXPORT = qw(install_host);

my $RPM_CMD;
my $LS_CMD;
my @PRODUCT_VERSION = ( "0", "0" ); # modify in install.pl

sub get_tools
{
    $RPM_CMD          =  $ENV{"RPM_CMD"};
    $LS_CMD           =  $ENV{"LS_CMD"};
    $PRODUCT_VERSION[0] = $ENV{"NETOP_PRODUCT_VERSION_MJ"};
    $PRODUCT_VERSION[1] = $ENV{"NETOP_PRODUCT_VERSION_MN"};
}

sub dbg
{
    if($DEBUG) {
        my $arg = shift(@_);
        print STDERR "DBG: $arg";
    }
}

sub install_public_key
{
    my ($mydir)=@_;
    my $keyid=system("./installpubkey '$mydir/netop.pub'");
}

sub install_rpm
{
    my $cmd = "";
    my ($install_dir,$rpmfile) = @_;
    install_public_key($install_dir);
    $cmd = "$RPM_CMD -U --nosignature $rpmfile";
    dbg("$cmd\n");
    my $res = system($cmd) ;
    if($res != 0) {
        print STDERR "install_rpm: '$cmd' failed with status $res\n";
        return 0;
    }
    return 1;
}

sub install_host()
{
    dbg("Install host from rpm\n");
    get_tools();
    my $res = 1;
    my ($install_dir) = @_;
    my $rpmfile = `$LS_CMD NetopHost*.rpm`;
    $rpmfile =~ s/\n//g;
    die "package not found\n" if(!($rpmfile =~ m|.*$PRODUCT_VERSION[0].$PRODUCT_VERSION[1]|));
    $cmd = "$RPM_CMD -q NetopHost";
    my $installed = `$cmd`;
    $installed =~ s/\n//g;
    if($installed =~ m|NetopHost-(....)-(........)|) {
        dbg("NetopHost allready installed : '$installed' !\n");
        if(-e "/etc/init.d/netophostd") {
            $cmd = "/etc/init.d/netophostd stop >/dev/null 2>/dev/null";
            dbg("$cmd\n");
            `$cmd`;
        }

        $cmd = "$RPM_CMD -e $installed";
        dbg("$cmd\n");
        `$cmd`;
    }
    return install_rpm($install_dir,$rpmfile);
}

sub install_guest()
{
    dbg("Install guest rpm\n");
    get_tools();
    my ($install_dir) = @_;
    my $rpmfile = `$LS_CMD NetopGuest*.rpm`;
    $rpmfile =~ s/\n//g;
    die "package not found\n" if(!($rpmfile =~ m|.*$PRODUCT_VERSION[0].$PRODUCT_VERSION[1]|));

    $cmd = "$RPM_CMD -q NetopGuest";
    my $installed = `$cmd`;
    $installed =~ s/\n//g;
    if($installed =~ m|NetopGuest-(....)-(........)|) {
        dbg("Netop Guest allready installed : '$installed' !\n");
        $cmd = "$RPM_CMD -e $installed";
        $res = system("$cmd");
        if($res != 0) {
            print STDERR "install_host: '$cmd' failed with status $res, trying to upgrade.\n";
        }
    }
    return install_rpm($install_dir,$rpmfile);
}

return 1;
